;===============================================================
;== GIMP Add Guides Vertically and Horizontally @ 50%         ==
;== Copyright (c) 2008 Gregory M. Ross                        ==
; 2020   canvas only center line guides - rich 
;===============================================================

(define (script-fu-crosshairs-canvas img drawable)
  
    (let* (

        (drawable   (car (gimp-image-active-drawable img)))
        (ImageW  (car (gimp-image-width img)))
        (ImageH (car (gimp-image-height img)))
	 
	    (Vert_50  (/ ImageW 2))
	    (Horz_50  (/ ImageH 2))
    )
   
    (gimp-image-undo-group-start img)
    (gimp-image-add-vguide img Vert_50)
    (gimp-image-add-hguide img Horz_50)
    (gimp-image-undo-group-end img)
    (gimp-displays-flush)))


(script-fu-register "script-fu-crosshairs-canvas"
		    "<Image>/Layer/Guides/Crosshair Guides Canvas"
		    "Add Guides at 50% to Canvas"
		    "Gregory M. Ross"
		    "Gregory M. Ross"
		    "March 2008"
		    ""
		    SF-IMAGE    "Image" 0
		    SF-DRAWABLE "Drawable" 0)
		    
